package jamezo97.clonecraft.dna;

import jamezo97.clonecraft.entity.EntityModifiable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;

public class GeneSuperJump extends Gene{

	
	
	public GeneSuperJump(int id) {
		super(id);
		// TODO Auto-generated constructor stub
	}

	@Override
	public String getName() {
		return "Super Jump";
	}

	@Override
	public int getMaxAmount() {
		return 1;
	}

	@Override
	public String getStringValue(int amount) {
		return "Super Jump";
	}

	@Override
	public int getColour() {
		return 0xffffb639;
	}

	@Override
	public Class[] getEntityClassesWithGene() {
		return new Class[]{EntitySpider.class, EntitySlime.class, EntityMagmaCube.class};
	}
	
	@Override
	public void addGeneEffect(EntityLivingBase entity, int level){
		entity.addPotionEffect(new PotionEffect(Potion.jump.id, Integer.MAX_VALUE, level));
	}
	
	@Override
	public void onUpdate(EntityLivingBase entity, IModifiable mod, int level) {
		if(!entity.isPotionActive(Potion.moveSpeed.id)){
			entity.addPotionEffect(new PotionEffect(Potion.jump.id, Integer.MAX_VALUE, level));
		}
	}

}
